/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import icyllis.modernui.ModernUI;
import icyllis.modernui.core.forge.Config;
import icyllis.modernui.core.forge.EventHandler;
import icyllis.modernui.core.forge.LocalStorage;
import icyllis.modernui.graphics.shader.ShaderProgram;
import icyllis.modernui.view.LayoutIO;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DatagenModLoader;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

@Mod(value="modernui")
public final class ModernUIForge
extends ModernUI {
    private static boolean optiFineLoaded;
    static boolean interceptTipTheScales;
    static boolean production;
    static boolean developerMode;
    private final Object2ObjectMap<String, IEventBus> mModEventBuses = new Object2ObjectOpenHashMap();

    public ModernUIForge() {
        boolean isDataGen = DatagenModLoader.isRunningDataGen();
        this.init();
        Config.init();
        LayoutIO.init();
        LocalStorage.init();
        if (FMLEnvironment.dist.isClient()) {
            if (!isDataGen) {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
                    if (predicate.test(VanillaResourceType.SHADERS)) {
                        ShaderProgram.recompile(manager);
                    }
                }));
            }
            if (production) {
                FMLJavaModLoadingContext.get().getModEventBus().register(EventHandler.ModClientExp.class);
            }
        }
        ModernUI.LOGGER.debug(ModernUI.MARKER, "Modern UI initialized");
    }

    private void init() {
        Path path = FMLPaths.GAMEDIR.get().getParent();
        File dir = path.toFile();
        String[] r = dir.list((file, name) -> name.equals("build.gradle"));
        if (r != null && r.length > 0 && dir.getName().equals("ModernUI")) {
            ModernUI.LOGGER.debug(ModernUI.MARKER, "Working in production environment");
            production = true;
        } else if (ModernUI.class.getSigners() == null) {
            ModernUI.LOGGER.debug(MARKER, "Signature is missing");
        }
        if (ModList.get().isLoaded("tipthescales") && !optiFineLoaded) {
            ModernUI.LOGGER.debug(ModernUI.MARKER, "Intercepting TipTheScales");
            interceptTipTheScales = true;
        }
        ModList.get().forEachModContainer((modid, container) -> {
            if (container instanceof FMLModContainer) {
                this.mModEventBuses.put(modid, (Object)((FMLModContainer)container).getEventBus());
            }
        });
    }

    @Override
    public void warnSetup(String key, Object ... args) {
        ModLoader.get().addWarning(new ModLoadingWarning(null, ModLoadingStage.SIDED_SETUP, key, args));
    }

    @Override
    @Nonnull
    public Locale getSelectedLocale() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale();
    }

    public static boolean isDeveloperMode() {
        return developerMode || production;
    }

    public static boolean isOptiFineLoaded() {
        return optiFineLoaded;
    }

    public static ModernUIForge get() {
        return (ModernUIForge)sInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean post(@Nullable String modid, @Nonnull Event event) {
        if (event instanceof IModBusEvent) {
            if (modid == null) {
                IEventBus bus;
                ObjectIterator objectIterator = this.mModEventBuses.values().iterator();
                do {
                    if (!objectIterator.hasNext()) return false;
                } while (!(bus = (IEventBus)objectIterator.next()).post(event));
                return true;
            }
            IEventBus bus = (IEventBus)this.mModEventBuses.get((Object)modid);
            if (bus == null) return false;
            if (!bus.post(event)) return false;
            return true;
        }
        LOGGER.warn(MARKER, "Posting a event that not implements IModBusEvent, {}", (Object)event);
        return false;
    }

    static {
        try {
            Class<?> clazz = Class.forName("optifine.Installer");
            String version = (String)clazz.getMethod("getOptiFineVersion", new Class[0]).invoke(null, new Object[0]);
            optiFineLoaded = true;
            ModernUI.LOGGER.debug(ModernUI.MARKER, "OptiFine installed: {}", (Object)version);
        }
        catch (ClassNotFoundException | NoSuchMethodException clazz) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

